IF OBJECT_ID('P_EXP_CTB_MOV_EST_NF_SAI') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EXP_CTB_MOV_EST_NF_SAI;
    END;
GO
--exec P_EXP_CTB_MOV_EST_NF_SAI 1,1,'20170127','20170127',0
CREATE PROCEDURE P_EXP_CTB_MOV_EST_NF_SAI(@CD_EMP      INT,
                                          @CD_FILIAL   INT,
                                          @DT_INI      DATETIME,
                                          @DT_FIM      DATETIME,
                                          @FLAG_LIMPAR INT      = 0)
WITH ENCRYPTION
AS
SET NOCOUNT ON;
    BEGIN TRY
        BEGIN
            DECLARE @RS_CD_EMP INT;
            DECLARE @RS_CD_FILIAL INT;
            DECLARE @RS_DT_CAD DATETIME;                  
            DECLARE @RS_DT_EMI_NF DATETIME;
            DECLARE @RS_CD_DEST INT;
            DECLARE @RS_NM_DEST VARCHAR(200);
            DECLARE @RS_HIST VARCHAR(200);
            DECLARE @RS_VLR_NF MONEY;
            DECLARE @RS_NF_NF INT;
            DECLARE @RS_NM_FANT VARCHAR(100);
            DECLARE @RS_VLR_ICMS_ITENS MONEY;
            DECLARE @RS_VLR_ICMS_SUBS_ITENS MONEY;
            DECLARE @RS_VLR_BASE_PIS_COFINS MONEY;
            DECLARE @RS_TP_MOV INT;
            DECLARE @RS_TP_MOV_DS VARCHAR(100);
            DECLARE @RS_DEST_ORIG INT;
            DECLARE @RS_CD_CTB_CNT_RED INT;
            DECLARE @RS_CD_CTB_CNT VARCHAR(50);
            DECLARE @RS_CD_MOV_OP INT;
            DECLARE @RET_DS_MOV_OP_CONTABIL VARCHAR(100);
            DECLARE @RET_CNT_CENTRO_CUSTO INT;
            DECLARE @RET_DS_CENTRO_CUSTO VARCHAR(100);
            DECLARE @RET_FLAG_APLICAR_CENTRO_CUSTO INT;
            DECLARE @RET_CD_CTB_CNT VARCHAR(100);
            DECLARE @RET_CD_CTB_CNT_RED INT;
            DECLARE @DADOS_NF_ICMS_SUBS_DESP_ATUAL VARCHAR(200);
            DECLARE @DADOS_NF_ICMS_SUBS_DESP_ANT VARCHAR(200);
            DECLARE @DADOS_NF_ICMS_DESP_ATUAL VARCHAR(200);
            DECLARE @DADOS_NF_ICMS_DESP_ANT VARCHAR(200);
            DECLARE @DADOS_NF_ATUAL VARCHAR(200);
            DECLARE @DADOS_NF_ANT VARCHAR(200);
            DECLARE @DADOS_NF_DESP_ATUAL VARCHAR(200);
            DECLARE @DADOS_NF_DESP_ANT VARCHAR(200);
            DECLARE @DADOS_NF_COFINS_DESP_ATUAL VARCHAR(200);
            DECLARE @DADOS_NF_COFINS_DESP_ANT VARCHAR(200);
            DECLARE @HIST VARCHAR(200);
            DECLARE @VLR_TEMP MONEY;
            DECLARE @PERC_COFINS MONEY;
            DECLARE @PERC_PIS MONEY;
            DECLARE @GERA_NOTAS_CANCELADAS_EXP_CONTABIL INT;  --  0 = envia canceladas ;  1 = nao envia canceladas
            DECLARE @STATUS VARCHAR(10);
            SET @PERC_PIS = ISNULL(
                                     (
                                         SELECT TOP 1 PERC_IMP
                                         FROM GLB_IMPOSTOS
                                         WHERE TIPO_IMPOSTO = 1
                                     ), 0);
            SET @PERC_COFINS = ISNULL(
                                  (
                                      SELECT TOP 1 PERC_IMP
                                      FROM GLB_IMPOSTOS
                                      WHERE TIPO_IMPOSTO = 2
                                  ), 0);
            SET @DADOS_NF_ICMS_SUBS_DESP_ATUAL = '';
            SET @DADOS_NF_ICMS_SUBS_DESP_ANT = '';
            SET @DADOS_NF_ICMS_DESP_ATUAL = '';
            SET @DADOS_NF_ICMS_DESP_ANT = '';
            SET @DADOS_NF_ATUAL = '';
            SET @DADOS_NF_ANT = '';
            SET @DADOS_NF_DESP_ATUAL = '';
            SET @DADOS_NF_DESP_ANT = '';
            SET @DADOS_NF_COFINS_DESP_ATUAL = '';
            SET @DADOS_NF_COFINS_DESP_ANT = '';
            SET @GERA_NOTAS_CANCELADAS_EXP_CONTABIL =
            (
                SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'NAO_ENVIA_NOTAS_CANCEL_EXP_CONTABIL', 0, 0)
            );
            SET @STATUS = '0';
            IF @GERA_NOTAS_CANCELADAS_EXP_CONTABIL = 0
                BEGIN
                    SET @STATUS = '0,1,3';
                END;
	
            ------------------------------------------------------------------------------------------------------------------------------
            --CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
            ------------------------------------------------------------------------------------------------------------------------------
            EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV
                 @FLAG_LIMPAR;
            DECLARE RS_RESULT CURSOR
            FOR SELECT CD_EMP
                     , CD_FILIAL
                     , DT_CAD
                     , DT_EMI_NF
                     , CD_DEST
                     , NM_DEST
                     , HIST
                     , VLR_NF
                     , NF_NF
                     , NM_FANT
                     , VLR_ICMS_ITENS
                     , VLR_ICMS_SUBS_ITENS
                     , VLR_BASE_PIS_COFINS
                     , TP_MOV
                     , TP_MOV_DS
                     , DEST_ORIG
                     , CD_CTB_CNT_RED
                     , CD_CTB_CNT
                     , CD_MOV_OP
                FROM V_EST_NF_SAI_CONTABIL
                WHERE CD_EMP = @CD_EMP
                      AND CD_FILIAL = @CD_FILIAL
                      AND DT_CAD BETWEEN @DT_INI AND @DT_FIM
                      AND STS_NF IN
                (
                    SELECT *
                    FROM DBO.UFD_PRM_IN_STRING(@STATUS)
                )
                ORDER BY CD_EMP
                       , CD_FILIAL
                       , DT_CAD
                       , NF_NF;				

            --Abrindo cursor
            OPEN RS_RESULT;
		
            --Atribuindo valores do select nas variveis
            FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_DT_CAD, @RS_DT_EMI_NF, @RS_CD_DEST, @RS_NM_DEST, @RS_HIST, @RS_VLR_NF, @RS_NF_NF, @RS_NM_FANT, @RS_VLR_ICMS_ITENS, @RS_VLR_ICMS_SUBS_ITENS, @RS_VLR_BASE_PIS_COFINS, @RS_TP_MOV, @RS_TP_MOV_DS, @RS_DEST_ORIG, @RS_CD_CTB_CNT_RED, @RS_CD_CTB_CNT, @RS_CD_MOV_OP;			
					 

            --Iniciando lao
            WHILE @@FETCH_STATUS = 0
                BEGIN	
				
                    --@TP_CONTA
                    --TipoEstoque = 0
                    --TipoIcmsPagar = 1
                    --TipoIcmsRecuperar = 2
                    --TipoPisRecuperar = 3
                    --TipoPisPagar = 4
                    --TipoCofinsRecuperar = 5
                    --TipoCofinsPagar = 6
                    --TipoIcmsSubst = 7

                    SET @DADOS_NF_ATUAL = CAST(@RS_DEST_ORIG AS VARCHAR)+'-'+CAST(@RS_VLR_NF AS VARCHAR)+'-'+CAST(@RS_NF_NF AS VARCHAR)+'-'+CAST(@RS_CD_FILIAL AS VARCHAR);												
				
                    ------------------------------------------------------------------------------------------------------------------
                    --CONTA ESTOQUE - NATUREZA DE OPERACAO
                    ------------------------------------------------------------------------------------------------------------------

                    IF @DADOS_NF_ANT <> @DADOS_NF_ATUAL
                        BEGIN
                            SET @DADOS_NF_ANT = @DADOS_NF_ATUAL;
                            SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                 , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                 , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                 , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                 , @RET_CD_CTB_CNT = CD_CTB_CNT
                                 , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                            FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 0, 1, @CD_FILIAL);


                            SET @HIST = 'VR. REF. '+@RET_DS_MOV_OP_CONTABIL+' DESTINATARIO '+@RS_NM_DEST+' CONF. DOC NR: '+(CASE
                                                                                                                                WHEN @RS_NF_NF = 0
                                                                                                                                THEN 'DIVERSOS'
                                                                                                                                ELSE RIGHT('00000000'+CAST(@RS_NF_NF AS VARCHAR), 8)
                                                                                                                            END);

					   if (@RET_DS_MOV_OP_CONTABIL) IS NULL 
						  BEGIN
							 SET @HIST = 'Natureza de Movimentao: '+ cast(@RS_CD_MOV_OP as varchar) + ' Sem contas contbeis cadastradas.'
						  END
						  
						SET @HIST = REPLACE (@HIST,'	',' ')
                            ------------------------------------------------------------------------------------------------------------------
                            --Contas estoque - Debito - Natureza de operao
                            ------------------------------------------------------------------------------------------------------------------
                            INSERT INTO ##CTB_EXP_MOV

							 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                   SELECT @RS_CD_EMP AS CD_EMP
                                        , @CD_FILIAL AS CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL AS CD_FILIAL
                                        , 14 AS CD_MOVIMENTO
                                        , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                        , '' AS OPERACAO
                                        , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' - DEBITO' AS OPERACAO_DEBITO
                                        , 0 AS CD_CNT_RED_CREDITO
                                        , '' AS CD_CNT_CREDITO
                                        , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                        , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                        , @RS_DT_EMI_NF AS DT_MOV
                                        , @HIST AS HIST
                                        , @RS_VLR_NF AS VLR_LANC
                                        , 'D' AS TP_TRANSA
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN 0
                                               ELSE 1
                                           END) AS RATEIO_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN ''
                                               ELSE @RET_DS_CENTRO_CUSTO
                                           END) AS DS_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN 0
                                               ELSE @RET_CNT_CENTRO_CUSTO
                                           END) AS CNT_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN 0
                                               ELSE @RS_VLR_NF
                                           END) AS VLR_CENTRO_CUSTO
                                        , 'NAT MOV 0-ESTOQUE' AS ORIG_CONTA
                                        , @RS_CD_MOV_OP AS COD_CONTA
                                        , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                        , '' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC
										,'' AS CD_BC_LANC;
											
                            SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                 , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                 , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                 , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                 , @RET_CD_CTB_CNT = CD_CTB_CNT
                                 , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                            FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 0, 0, @CD_FILIAL);
                            SET @HIST = 'VR. REF. '+@RET_DS_MOV_OP_CONTABIL+' DESTINATARIO '+@RS_NM_DEST+' CONF. DOC NR: '+(CASE
                                                                                                                                WHEN @RS_NF_NF = 0
                                                                                                                                THEN 'DIVERSOS'
                                                                                                                                ELSE RIGHT('00000000'+CAST(@RS_NF_NF AS VARCHAR), 8)
                                                                                                                            END);
						
						SET @HIST = REPLACE (@HIST,'	',' ')
                            ------------------------------------------------------------------------------------------------------------------
                            --Contas estoque - Credito - Natureza de operao e despesas
                            ------------------------------------------------------------------------------------------------------------------
                            INSERT INTO ##CTB_EXP_MOV

					   		 (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                   SELECT @RS_CD_EMP AS CD_EMP
                                        , @CD_FILIAL AS CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL AS CD_FILIAL
                                        , 14 AS CD_MOVIMENTO
                                        , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                        , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' - CREDITO' AS OPERACAO
                                        , '' AS OPERACAO_DEBITO
                                        , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_CREDITO
                                        , @RET_CD_CTB_CNT AS CD_CNT_CREDITO
                                        , 0 AS CD_CNT_RED_DEBITO
                                        , '' AS CD_CNT_DEBITO
                                        , @RS_DT_EMI_NF AS DT_MOV
                                        , @HIST AS HIST
                                        , @RS_VLR_NF AS VLR_LANC
                                        , 'C' AS TP_TRANSA
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN 0
                                               ELSE 1
                                           END) AS RATEIO_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN ''
                                               ELSE @RET_DS_CENTRO_CUSTO
                                           END) AS DS_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN 0
                                               ELSE @RET_CNT_CENTRO_CUSTO
                                           END) AS CNT_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                               THEN 0
                                               ELSE @RS_VLR_NF
                                           END) AS VLR_CENTRO_CUSTO
                                        , 'NAT MOV 0-ESTOQUE' AS ORIG_CONTA
                                        , @RS_CD_MOV_OP AS COD_CONTA
                                        , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                        , '' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
								, 0  AS NR_DP
								, 0  AS ANO
								, @RS_NF_NF AS NR_DOC
								, '' CD_BC_LANC;	
                        END;
                    IF @RS_VLR_ICMS_ITENS > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --CONTA ICMS A PAGAR - NATUREZA DE OPERACAO
                            ------------------------------------------------------------------------------------------------------------------
                            SET @DADOS_NF_ICMS_DESP_ATUAL = CAST(@RS_VLR_ICMS_ITENS AS VARCHAR)+'-'+@DADOS_NF_ATUAL;
                            IF @DADOS_NF_ICMS_DESP_ATUAL <> @DADOS_NF_ICMS_DESP_ANT
                                BEGIN
                                    SET @DADOS_NF_ICMS_DESP_ANT = CAST(@RS_VLR_ICMS_ITENS AS VARCHAR)+'-'+@DADOS_NF_ATUAL;
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 1, 1, @CD_FILIAL);
                                    SET @HIST = 'VR. REF. ICMS S/'+@RET_DS_MOV_OP_CONTABIL+' DESTINATARIO '+@RS_NM_DEST+' CONF. DOC NR: '+(CASE
                                                                                                                                               WHEN @RS_NF_NF = 0
                                                                                                                                               THEN 'DIVERSOS'
                                                                                                                                               ELSE RIGHT('00000000'+CAST(@RS_NF_NF AS VARCHAR), 8)
                                                                                                                                           END);
								SET @HIST = REPLACE (@HIST,'	',' ')
                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas ICMS Pagar - Debito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    INSERT INTO ##CTB_EXP_MOV

					   			    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , '' AS OPERACAO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' ICMS - DEBITO' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VLR_ICMS_ITENS AS VLR_LANC
                                                , 'D' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RS_VLR_ICMS_ITENS
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 1-ICMS' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @RS_NF_NF AS NR_DOC
									   , '' AS CD_BC_LANC;	
											
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 1, 0, @CD_FILIAL);
								
                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas ICMS pagar - Credito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' ICMS - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_CREDITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VLR_ICMS_ITENS AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RS_VLR_ICMS_ITENS
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 1-ICMS' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , 0  AS NR_DP
									   , 0  AS ANO
									   , @RS_NF_NF AS NR_DOC
									   , '' CD_BC_LANC;	
                                END;
                        END;
                    IF @RS_VLR_BASE_PIS_COFINS > 0
                        BEGIN						    											
                            ------------------------------------------------------------------------------------------------------------------
                            --CONTA COFINS A RECUPERAR - NATUREZA DE OPERACAO
                            ------------------------------------------------------------------------------------------------------------------
                            SET @DADOS_NF_COFINS_DESP_ATUAL = CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR)+'-'+@DADOS_NF_ATUAL;
                            IF @DADOS_NF_COFINS_DESP_ATUAL <> @DADOS_NF_COFINS_DESP_ANT
                                BEGIN
                                    SET @DADOS_NF_COFINS_DESP_ANT = CAST(@RS_VLR_BASE_PIS_COFINS AS VARCHAR)+'-'+@DADOS_NF_ATUAL;
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 6, 1, @CD_FILIAL);
                                    SET @HIST = 'VR. REF. COFINS S/'+@RET_DS_MOV_OP_CONTABIL+' DESTINATARIO '+@RS_NM_DEST+' CONF. DOC NR: '+(CASE
                                                                                                                                                 WHEN @RS_NF_NF = 0
                                                                                                                                                 THEN 'DIVERSOS'
                                                                                                                                                 ELSE RIGHT('00000000'+CAST(@RS_NF_NF AS VARCHAR), 8)
                                                                                                                                             END);
                                    SET @VLR_TEMP = ROUND((@RS_VLR_BASE_PIS_COFINS * @PERC_COFINS) / 100, 2);
                                    IF @PERC_COFINS = 0
                                        BEGIN
                                            SET @RET_CD_CTB_CNT = 'PERCENTUAL DO COFINS NAO INFORMADO';
                                        END;
								SET @HIST = REPLACE (@HIST,'	',' ')
                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas Estoque - Debito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , '' AS OPERACAO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' COFINS - DEBITO' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @VLR_TEMP AS VLR_LANC
                                                , 'D' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @VLR_TEMP
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 6-COFINS' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC
										, '' AS CD_BC_LANC;																	

                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas COFINS pagar - Debito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 6, 0, @CD_FILIAL);
                                    IF @PERC_COFINS = 0
                                        BEGIN
                                            SET @RET_CD_CTB_CNT = 'PERCENTUAL DO COFINS NAO INFORMADO';
                                        END;
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' COFINS - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_CREDITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @VLR_TEMP AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @VLR_TEMP
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 6-COFINS' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC
										, '' AS CD_BC_LANC;																												
					    											
                                    ------------------------------------------------------------------------------------------------------------------
                                    --CONTA PIS A RECUPERAR - NATUREZA DE OPERACAO
                                    ------------------------------------------------------------------------------------------------------------------
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 4, 1, @CD_FILIAL);
                                    SET @HIST = 'VR. REF. PIS S/'+@RET_DS_MOV_OP_CONTABIL+' DESTINATARIO '+@RS_NM_DEST+' CONF. DOC NR: '+(CASE
                                                                                                                                              WHEN @RS_NF_NF = 0
                                                                                                                                              THEN 'DIVERSOS'
                                                                                                                                              ELSE RIGHT('00000000'+CAST(@RS_NF_NF AS VARCHAR), 8)
                                                                                                                                          END);
                                    SET @VLR_TEMP = ROUND((@RS_VLR_BASE_PIS_COFINS * @PERC_PIS) / 100, 2);
                                    IF @PERC_PIS = 0
                                        BEGIN
                                            SET @RET_CD_CTB_CNT = 'PERCENTUAL DO PIS NAO INFORMADO';
                                        END;
								SET @HIST = REPLACE (@HIST,'	',' ')
								
                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas ESTOQUE - Debito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , '' AS OPERACAO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' PIS - DEBITO' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @VLR_TEMP AS VLR_LANC
                                                , 'D' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @VLR_TEMP
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 4-PIS' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC
										, '' CD_BC_LANC;																

                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas PIS pagar - Credito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 4, 0, @CD_FILIAL);
                                    IF @PERC_PIS = 0
                                        BEGIN
                                            SET @RET_CD_CTB_CNT = 'PERCENTUAL DO PIS NAO INFORMADO';
                                        END;
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' PIS - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_CREDITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @VLR_TEMP AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @VLR_TEMP
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 4-PIS' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC
										, '' CD_BC_LANC;		
                                END;
                        END;
                    IF @RS_VLR_ICMS_SUBS_ITENS > 0
                        BEGIN
                            ------------------------------------------------------------------------------------------------------------------
                            --CONTA ICMS SUBST A RECUPERAR - NATUREZA DE OPERACAO
                            ------------------------------------------------------------------------------------------------------------------
                            SET @DADOS_NF_ICMS_SUBS_DESP_ATUAL = CAST(@RS_VLR_ICMS_SUBS_ITENS AS VARCHAR)+'-'+@DADOS_NF_ATUAL;
                            IF @DADOS_NF_ICMS_SUBS_DESP_ATUAL <> @DADOS_NF_ICMS_SUBS_DESP_ANT
                                BEGIN
                                    SET @DADOS_NF_ICMS_SUBS_DESP_ANT = CAST(@RS_VLR_ICMS_SUBS_ITENS AS VARCHAR)+'-'+@DADOS_NF_ATUAL;
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 7, 0, @CD_FILIAL);
                                    SET @HIST = 'VR. REF. ICMS SUBST S/'+@RET_DS_MOV_OP_CONTABIL+' DESTINATARIO '+@RS_NM_DEST+' CONF. DOC NR: '+(CASE
                                                                                                                                                     WHEN @RS_NF_NF = 0
                                                                                                                                                     THEN 'DIVERSOS'
                                                                                                                                                     ELSE RIGHT('00000000'+CAST(@RS_NF_NF AS VARCHAR), 8)
                                                                                                                                                 END);
								SET @HIST = REPLACE (@HIST,'	',' ')
                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas ESTOQUE - Credito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' ICMS SUBST - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_CREDITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VLR_ICMS_SUBS_ITENS AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RS_VLR_ICMS_SUBS_ITENS
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 7-SUBST' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC,
										'' CD_BC_LANC;																

                                    ------------------------------------------------------------------------------------------------------------------
                                    --Contas ICMS SUBST recuperar - Debito - Natureza de operao
                                    ------------------------------------------------------------------------------------------------------------------
                                    SELECT @RET_DS_MOV_OP_CONTABIL = DS_MOV_OP_CONTABIL
                                         , @RET_CNT_CENTRO_CUSTO = CNT_CENTRO_CUSTO
                                         , @RET_DS_CENTRO_CUSTO = DS_CENTRO_CUSTO
                                         , @RET_FLAG_APLICAR_CENTRO_CUSTO = FLAG_APLICAR_CENTRO_CUSTO
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                    FROM UFD_BUSCA_CONTA_MOV(@CD_EMP, @RS_CD_MOV_OP, 7, 1, @CD_FILIAL);
                                    							 
							 INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,CD_FILIAL_EXPORT, CD_FILIAL,  CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 14 AS CD_MOVIMENTO
                                                , 'MOVIMENTACAO ESTOQUE SAIDA' AS MOVIMENTO
                                                , '' AS OPERACAO
                                                , 'APROPRIAR '+@RET_DS_MOV_OP_CONTABIL+' ICMS SUBST - DEBITO' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                , @RS_DT_EMI_NF AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VLR_ICMS_SUBS_ITENS AS VLR_LANC
                                                , 'D' AS TP_TRANSA
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE 1
                                                   END) AS RATEIO_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN ''
                                                       ELSE @RET_DS_CENTRO_CUSTO
                                                   END) AS DS_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RET_CNT_CENTRO_CUSTO
                                                   END) AS CNT_CENTRO_CUSTO
                                                , (CASE
                                                       WHEN @RET_FLAG_APLICAR_CENTRO_CUSTO = 0
                                                       THEN 0
                                                       ELSE @RS_VLR_ICMS_SUBS_ITENS
                                                   END) AS VLR_CENTRO_CUSTO
                                                , 'NAT MOV 7-SUBST' AS ORIG_CONTA
                                                , @RS_CD_MOV_OP AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , '' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
										, 0  AS NR_DP
										, 0  AS ANO
										, @RS_NF_NF AS NR_DOC
										, '' CD_BC_LANC;		
                                END;
                        END;					

                    ------------------------------------------------------------------------------------------------------------------
                    --Prximo registro				
                    ------------------------------------------------------------------------------------------------------------------
                    --Atribuindo valores do select nas variveis
                    FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_DT_CAD, @RS_DT_EMI_NF, @RS_CD_DEST, @RS_NM_DEST, @RS_HIST, @RS_VLR_NF, @RS_NF_NF, @RS_NM_FANT, @RS_VLR_ICMS_ITENS, @RS_VLR_ICMS_SUBS_ITENS, @RS_VLR_BASE_PIS_COFINS, @RS_TP_MOV, @RS_TP_MOV_DS, @RS_DEST_ORIG, @RS_CD_CTB_CNT_RED, @RS_CD_CTB_CNT, @RS_CD_MOV_OP;
                END;
            CLOSE RS_RESULT;
            DEALLOCATE RS_RESULT;
        END;
    END TRY
    BEGIN CATCH
        CLOSE RS_RESULT;
        DEALLOCATE RS_RESULT;
        INSERT INTO ADM_ERRO
        (numero
       , severidade
       , estado
       , rotina
       , linha
       , mensagem
       , dtErro
        )
               SELECT ERROR_NUMBER() AS numero
                    , ERROR_SEVERITY() AS severidade
                    , ERROR_STATE() AS estado
                    , ERROR_PROCEDURE() AS rotina
                    , ERROR_LINE() AS linha
                    , ERROR_MESSAGE() AS mensagem
                    , GETDATE() AS dtErro;
    END CATCH;